// This is a part of the ZD Screen Recorder SDK.
// Copyright (C) 2005-2024, ZD Soft, all rights reserved.

#ifndef __SCNLIB_H__
#define __SCNLIB_H__

#include <tchar.h>
#include <windows.h>

#define SCNLIB_POSITION_TOP_LEFT        0
#define SCNLIB_POSITION_TOP             1
#define SCNLIB_POSITION_TOP_RIGHT       2
#define SCNLIB_POSITION_RIGHT           3
#define SCNLIB_POSITION_BOTTOM_RIGHT    4
#define SCNLIB_POSITION_BOTTOM          5
#define SCNLIB_POSITION_BOTTOM_LEFT     6
#define SCNLIB_POSITION_LEFT            7
#define SCNLIB_POSITION_CENTER          8

#define SCNLIB_WEBCAM_VIEW_PADDING      0
#define SCNLIB_WEBCAM_VIEW_CROPPING     1
#define SCNLIB_WEBCAM_VIEW_STRETCHING   2

#ifdef SCNLIB_EXPORT
#define SCNLIB_API __declspec(dllexport)
#else
#define SCNLIB_API __declspec(dllimport)
#endif

#ifdef __cplusplus
extern "C" {
#endif

SCNLIB_API void __stdcall ScnLib_About(void);
SCNLIB_API BOOL __stdcall ScnLib_SetLicenseA(LPCSTR pcszName, LPCSTR pcszEmail, LPCSTR pcszKey);
SCNLIB_API BOOL __stdcall ScnLib_SetLicenseW(LPCWSTR pcwszName, LPCWSTR pcwszEmail, LPCWSTR pcwszKey);
SCNLIB_API BOOL __stdcall ScnLib_CheckComponents(void);
SCNLIB_API DWORD __stdcall ScnLib_GetLastError(void);
SCNLIB_API BOOL __stdcall ScnLib_InitializeA(LPCSTR pcszSubDir);
SCNLIB_API BOOL __stdcall ScnLib_InitializeW(LPCWSTR pcwszSubDir);
SCNLIB_API void __stdcall ScnLib_Uninitialize(void);
SCNLIB_API BOOL __stdcall ScnLib_LoadSettingsA(HKEY hKey, LPCSTR pcszSubKey);
SCNLIB_API BOOL __stdcall ScnLib_LoadSettingsW(HKEY hKey, LPCWSTR pcwszSubKey);
SCNLIB_API BOOL __stdcall ScnLib_SaveSettingsA(HKEY hKey, LPCSTR pcszSubKey);
SCNLIB_API BOOL __stdcall ScnLib_SaveSettingsW(HKEY hKey, LPCWSTR pcwszSubKey);
SCNLIB_API BOOL __stdcall ScnLib_DeleteSettingsA(HKEY hKey, LPCSTR pcszSubKey);
SCNLIB_API BOOL __stdcall ScnLib_DeleteSettingsW(HKEY hKey, LPCWSTR pcwszSubKey);
SCNLIB_API void __stdcall ScnLib_ConfigureSettings(HWND hwndParent);
SCNLIB_API void __stdcall ScnLib_SetLogPathA(LPCSTR pcszPath, BOOL bNewLog);
SCNLIB_API void __stdcall ScnLib_GetLogPathA(LPSTR pszPath); // pszPath >= 260 CHARs
SCNLIB_API void __stdcall ScnLib_SetLogPathW(LPCWSTR pcwszPath, BOOL bNewLog);
SCNLIB_API void __stdcall ScnLib_GetLogPathW(LPWSTR pwszPath); // pwszPath >= 260 WCHARs
SCNLIB_API void __stdcall ScnLib_SetVideoPathA(LPCSTR pcszPath);
SCNLIB_API void __stdcall ScnLib_GetVideoPathA(LPSTR pszPath, BOOL bSaved); // pszPath >= 260 CHARs
SCNLIB_API void __stdcall ScnLib_SetVideoPathW(LPCWSTR pcwszPath);
SCNLIB_API void __stdcall ScnLib_GetVideoPathW(LPWSTR pwszPath, BOOL bSaved); // pwszPath >= 260 WCHARs
SCNLIB_API void __stdcall ScnLib_SetAudioPathA(LPCSTR pcszPath);
SCNLIB_API void __stdcall ScnLib_GetAudioPathA(LPSTR pszPath, BOOL bSaved); // pszPath >= 260 CHARs
SCNLIB_API void __stdcall ScnLib_SetAudioPathW(LPCWSTR pcwszPath);
SCNLIB_API void __stdcall ScnLib_GetAudioPathW(LPWSTR pwszPath, BOOL bSaved); // pwszPath >= 260 WCHARs
SCNLIB_API void __stdcall ScnLib_SetStreamingUrlA(LPCSTR pcszURL, LPCSTR pcszKey);
SCNLIB_API void __stdcall ScnLib_GetStreamingUrlA(LPSTR pszURL, LPSTR pszKey); // pszURL, pszKey >= 2048 CHARs
SCNLIB_API void __stdcall ScnLib_SetStreamingUrlW(LPCWSTR pcwszURL, LPCWSTR pcwszKey);
SCNLIB_API void __stdcall ScnLib_GetStreamingUrlW(LPWSTR pwszURL, LPWSTR pwszKey); // pwszURL, pwszKey >= 2048 WCHARs
SCNLIB_API BOOL __stdcall ScnLib_TakeScreenshotA(LPSTR pszPath, long left, long top, long right, long bottom); // pszPath >= 260 CHARs
SCNLIB_API BOOL __stdcall ScnLib_TakeScreenshotW(LPWSTR pwszPath, long left, long top, long right, long bottom); // pwszPath >= 260 WCHARs
SCNLIB_API HWND __stdcall ScnLib_SetCaptureWnd(HWND hWnd, BOOL bExclusive);
SCNLIB_API HWND __stdcall ScnLib_GetCaptureWnd(void);
SCNLIB_API void __stdcall ScnLib_SetCaptureRegion(long left, long top, long right, long bottom);
SCNLIB_API void __stdcall ScnLib_GetCaptureRegion(long *left, long *top, long *right, long *bottom);
SCNLIB_API BOOL __stdcall ScnLib_SelectCaptureRegionA(long *left, long *top, long *right, long *bottom, HWND *pHWND, LPCSTR pcszTip);
SCNLIB_API BOOL __stdcall ScnLib_SelectCaptureRegionW(long *left, long *top, long *right, long *bottom, HWND *pHWND, LPCWSTR pcwszTip);
SCNLIB_API void __stdcall ScnLib_ShowCaptureRegionFrame(BOOL bEnable);
SCNLIB_API HWND __stdcall ScnLib_GetCaptureRegionFrameWnd(void);
SCNLIB_API void __stdcall ScnLib_LockCaptureRegionFrameAspectRatio(BOOL bEnable);
SCNLIB_API BOOL __stdcall ScnLib_IsCaptureRegionFrameAspectRatioLocked(void);
SCNLIB_API void __stdcall ScnLib_EnableGPUAcceleration(BOOL bEnable);
SCNLIB_API BOOL __stdcall ScnLib_IsGPUAccelerationEnabled(void);
SCNLIB_API void __stdcall ScnLib_EnableGameCaptureMode(BOOL bEnable);
SCNLIB_API BOOL __stdcall ScnLib_IsGameCaptureModeEnabled(void);
SCNLIB_API void __stdcall ScnLib_GetGamePathA(LPSTR pszPath); // pszPath >= 260 CHARs
SCNLIB_API void __stdcall ScnLib_GetGamePathW(LPWSTR pwszPath); // pwszPath >= 260 WCHARs
SCNLIB_API HWND __stdcall ScnLib_GetGameWnd(void);
SCNLIB_API int __stdcall ScnLib_GetGameFrameRate(void);
SCNLIB_API void __stdcall ScnLib_ShowInGameOverlay(const PVOID pRGB, int nWidth, int nHeight, int nBitCount);
SCNLIB_API void __stdcall ScnLib_SetInGameOverlayPosition(int nPosition, int nMarginX, int nMarginY);
SCNLIB_API void __stdcall ScnLib_GetInGameOverlayPosition(int *nPosition, int *nMarginX, int *nMarginY);
SCNLIB_API BOOL __stdcall ScnLib_ShowCountdownBox(int nSeconds);
SCNLIB_API BOOL __stdcall ScnLib_StartRecording(void);
SCNLIB_API BOOL __stdcall ScnLib_PauseRecording(void);
SCNLIB_API BOOL __stdcall ScnLib_ResumeRecording(void);
SCNLIB_API void __stdcall ScnLib_StopRecording(void);
SCNLIB_API BOOL __stdcall ScnLib_IsRecording(void);
SCNLIB_API BOOL __stdcall ScnLib_IsStreaming(void);
SCNLIB_API BOOL __stdcall ScnLib_IsPaused(void);
SCNLIB_API DWORD __stdcall ScnLib_GetRecTime(void);
SCNLIB_API void __stdcall ScnLib_GetRecTimeA(LPSTR pszTime); // pszTime >= 11 CHARs
SCNLIB_API void __stdcall ScnLib_GetRecTimeW(LPWSTR pwszTime); // pwszTime >= 11 WCHARs
SCNLIB_API void __stdcall ScnLib_ZoomInScreen(double dRatio);
SCNLIB_API double __stdcall ScnLib_GetZoomRatio(void);
SCNLIB_API void __stdcall ScnLib_SetZoomSpeed(double dSpeed);
SCNLIB_API double __stdcall ScnLib_GetZoomSpeed(void);
SCNLIB_API BOOL __stdcall ScnLib_PreviewVideo(BOOL bEnable, HWND hWnd, BOOL bPadding, COLORREF crBkColor);
SCNLIB_API HWND __stdcall ScnLib_GetVideoPreviewWnd(void);
SCNLIB_API void __stdcall ScnLib_EnableVideoRecovery(BOOL bEnable);
SCNLIB_API BOOL __stdcall ScnLib_IsVideoRecoveryEnabled(void);
SCNLIB_API BOOL __stdcall ScnLib_RecoverVideoFileA(LPCSTR pcszFromPath, LPCSTR pcszToPath);
SCNLIB_API BOOL __stdcall ScnLib_RecoverVideoFileW(LPCWSTR pcwszFromPath, LPCWSTR pcwszToPath);
SCNLIB_API int __stdcall ScnLib_GetVideoRecoveryProgress(void);
SCNLIB_API void __stdcall ScnLib_SetVideoResolution(int nWidth, int nHeight);
SCNLIB_API void __stdcall ScnLib_GetVideoResolution(int *nWidth, int *nHeight);
SCNLIB_API void __stdcall ScnLib_SetVideoFrameRate(double dFPS);
SCNLIB_API double __stdcall ScnLib_GetVideoFrameRate(void);
SCNLIB_API void __stdcall ScnLib_SetVideoKeyFrameInterval(double dSeconds);
SCNLIB_API double __stdcall ScnLib_GetVideoKeyFrameInterval(void);
SCNLIB_API void __stdcall ScnLib_EnableVideoVariableFrameRate(BOOL bEnable);
SCNLIB_API BOOL __stdcall ScnLib_IsVideoVariableFrameRateEnabled(void);
SCNLIB_API void __stdcall ScnLib_SetVideoPresetProfileA(LPCSTR pcszPreset, LPCSTR pcszProfile);
SCNLIB_API void __stdcall ScnLib_GetVideoPresetProfileA(LPSTR pszPreset, LPSTR pszProfile); // pszPreset, pszProfile >= 30 CHARs
SCNLIB_API void __stdcall ScnLib_SetVideoPresetProfileW(LPCWSTR pcwszPreset, LPCWSTR pcwszProfile);
SCNLIB_API void __stdcall ScnLib_GetVideoPresetProfileW(LPWSTR pwszPreset, LPWSTR pwszProfile); // pwszPreset, pwszProfile >= 30 WCHARs
SCNLIB_API void __stdcall ScnLib_SetVideoQuality(int nCRF);
SCNLIB_API int __stdcall ScnLib_GetVideoQuality(void);
SCNLIB_API void __stdcall ScnLib_SetVideoBitrate(int nKbps);
SCNLIB_API int __stdcall ScnLib_GetVideoBitrate(void);
SCNLIB_API DWORD __stdcall ScnLib_GetVideoTime(void);
SCNLIB_API void __stdcall ScnLib_SetAudioBitrate(int nKbps);
SCNLIB_API int __stdcall ScnLib_GetAudioBitrate(void);
SCNLIB_API DWORD __stdcall ScnLib_GetAudioTime(void);
SCNLIB_API void __stdcall ScnLib_SetStreamingBitrate(int nKbps);
SCNLIB_API int __stdcall ScnLib_GetStreamingBitrate(void);
SCNLIB_API int __stdcall ScnLib_GetAudioSourceDeviceCount(BOOL bPlayback);
SCNLIB_API BOOL __stdcall ScnLib_GetAudioSourceDeviceA(BOOL bPlayback, int nIndex, LPSTR pszDevice, LPSTR pszDeviceID); // pszDevice, pszDeviceID >= 260 CHARs
SCNLIB_API BOOL __stdcall ScnLib_GetAudioSourceDeviceW(BOOL bPlayback, int nIndex, LPWSTR pwszDevice, LPWSTR pwszDeviceID); // pwszDevice, pwszDeviceID >= 260 WCHARs
SCNLIB_API BOOL __stdcall ScnLib_SelectAudioSourceDevice(BOOL bPlayback, int nIndex);
SCNLIB_API int __stdcall ScnLib_GetSelectedAudioSourceDevice(BOOL bPlayback);
SCNLIB_API void __stdcall ScnLib_ConfigureAudioSourceDevices(BOOL bPlayback);
SCNLIB_API void __stdcall ScnLib_RecordAudioSource(BOOL bPlayback, BOOL bEnable);
SCNLIB_API BOOL __stdcall ScnLib_IsRecordAudioSource(BOOL bPlayback);
SCNLIB_API void __stdcall ScnLib_SetAudioSourceVolume(BOOL bPlayback, int nVolume);
SCNLIB_API int __stdcall ScnLib_GetAudioSourceVolume(BOOL bPlayback);
SCNLIB_API void __stdcall ScnLib_MonitorVolumeLevel(BOOL bEnable);
SCNLIB_API BOOL __stdcall ScnLib_IsMonitoringVolumeLevel(void);
SCNLIB_API int __stdcall ScnLib_GetAudioSourceVolumeLevel(BOOL bPlayback);
SCNLIB_API void __stdcall ScnLib_SetMicrophoneDelay(int nMilliseconds);
SCNLIB_API int __stdcall ScnLib_GetMicrophoneDelay(void);
SCNLIB_API int __stdcall ScnLib_SetLayoutContext(int nBlock);
SCNLIB_API int __stdcall ScnLib_GetLayoutContext(void);
SCNLIB_API int __stdcall ScnLib_GetWebcamDeviceCount(void);
SCNLIB_API BOOL __stdcall ScnLib_GetWebcamDeviceA(int nIndex, LPSTR pszDevice, LPSTR pszDeviceID); // pszDevice, pszDeviceID >= 260 CHARs
SCNLIB_API BOOL __stdcall ScnLib_GetWebcamDeviceW(int nIndex, LPWSTR pwszDevice, LPWSTR pwszDeviceID); // pwszDevice, pwszDeviceID >= 260 WCHARs
SCNLIB_API BOOL __stdcall ScnLib_SelectWebcamDevice(int nIndex);
SCNLIB_API int __stdcall ScnLib_GetSelectedWebcamDevice(void);
SCNLIB_API BOOL __stdcall ScnLib_PreviewWebcam(BOOL bEnable, HWND hWnd, BOOL bPadding, COLORREF crBkColor);
SCNLIB_API HWND __stdcall ScnLib_GetWebcamPreviewWnd(void);
SCNLIB_API void __stdcall ScnLib_RecordWebcamOnly(BOOL bEnable);
SCNLIB_API BOOL __stdcall ScnLib_IsRecordWebcamOnly(void);
SCNLIB_API void __stdcall ScnLib_InputWebcamFrame(const PVOID pRGB, int nWidth, int nHeight, int nBitCount);
SCNLIB_API void __stdcall ScnLib_SetWebcamResolution(int nWidth, int nHeight);
SCNLIB_API void __stdcall ScnLib_GetWebcamResolution(int *nWidth, int *nHeight);
SCNLIB_API void __stdcall ScnLib_SetWebcamDirection(BOOL bMirroring, BOOL bFlipping);
SCNLIB_API void __stdcall ScnLib_GetWebcamDirection(BOOL *bMirroring, BOOL *bFlipping);
SCNLIB_API void __stdcall ScnLib_SetWebcamViewMode(int nViewMode);
SCNLIB_API int __stdcall ScnLib_GetWebcamViewMode(void);
SCNLIB_API void __stdcall ScnLib_SetWebcamPosition(int nPosition, int nMarginX, int nMarginY);
SCNLIB_API void __stdcall ScnLib_GetWebcamPosition(int *nPosition, int *nMarginX, int *nMarginY);
SCNLIB_API void __stdcall ScnLib_SetWebcamViewSize(int nViewWidth, int nViewHeight);
SCNLIB_API void __stdcall ScnLib_GetWebcamViewSize(int *nViewWidth, int *nViewHeight);
SCNLIB_API BOOL __stdcall ScnLib_IsLogoImagePresent(void);
SCNLIB_API BOOL __stdcall ScnLib_SetLogoImageA(LPCSTR pcszPath);
SCNLIB_API void __stdcall ScnLib_GetLogoImageA(LPSTR pszPath); // pszPath >= 260 CHARs
SCNLIB_API BOOL __stdcall ScnLib_SetLogoImageW(LPCWSTR pcwszPath);
SCNLIB_API void __stdcall ScnLib_GetLogoImageW(LPWSTR pwszPath); // pwszPath >= 260 WCHARs
SCNLIB_API void __stdcall ScnLib_UpdateLogoImage(const PVOID pRGB, int nWidth, int nHeight, int nBitCount);
SCNLIB_API void __stdcall ScnLib_SetLogoImagePosition(int nPosition, int nMarginX, int nMarginY);
SCNLIB_API void __stdcall ScnLib_GetLogoImagePosition(int *nPosition, int *nMarginX, int *nMarginY);
SCNLIB_API void __stdcall ScnLib_SetLogoImageOpacity(double dOpacity);
SCNLIB_API double __stdcall ScnLib_GetLogoImageOpacity(void);
SCNLIB_API BOOL __stdcall ScnLib_IsLogoTextPresent(void);
SCNLIB_API BOOL __stdcall ScnLib_SetLogoTextA(LPCSTR pcszText);
SCNLIB_API void __stdcall ScnLib_GetLogoTextA(LPSTR pszText); // pszText >= 1024 CHARs
SCNLIB_API BOOL __stdcall ScnLib_SetLogoTextW(LPCWSTR pcwszText);
SCNLIB_API void __stdcall ScnLib_GetLogoTextW(LPWSTR pwszText); // pwszText >= 1024 WCHARs
SCNLIB_API BOOL __stdcall ScnLib_SetLogoTextStyleA(const LOGFONTA *lfFont, COLORREF crColor, BOOL bShadow);
SCNLIB_API void __stdcall ScnLib_GetLogoTextStyleA(LOGFONTA *lfFont, COLORREF *crColor, BOOL *bShadow);
SCNLIB_API BOOL __stdcall ScnLib_SetLogoTextStyleW(const LOGFONTW *lfFont, COLORREF crColor, BOOL bShadow);
SCNLIB_API void __stdcall ScnLib_GetLogoTextStyleW(LOGFONTW *lfFont, COLORREF *crColor, BOOL *bShadow);
SCNLIB_API void __stdcall ScnLib_SetLogoTextPosition(int nPosition, int nMarginX, int nMarginY);
SCNLIB_API void __stdcall ScnLib_GetLogoTextPosition(int *nPosition, int *nMarginX, int *nMarginY);
SCNLIB_API void __stdcall ScnLib_SetLogoTextOpacity(double dOpacity);
SCNLIB_API double __stdcall ScnLib_GetLogoTextOpacity(void);
SCNLIB_API void __stdcall ScnLib_RecordCursor(BOOL bEnable);
SCNLIB_API BOOL __stdcall ScnLib_IsRecordCursor(void);
SCNLIB_API void __stdcall ScnLib_SetCursorUnscaled(BOOL bEnable);
SCNLIB_API BOOL __stdcall ScnLib_IsCursorUnscaled(void);
SCNLIB_API void __stdcall ScnLib_AddCursorEffects(BOOL bHighlight, BOOL bClickEffects, BOOL bTrack, BOOL bClickSound);
SCNLIB_API void __stdcall ScnLib_GetCursorEffects(BOOL *bHighlight, BOOL *bClickEffects, BOOL *bTrack, BOOL *bClickSound);
SCNLIB_API void __stdcall ScnLib_SetCursorEffectsColors(COLORREF crHighlight, COLORREF crLeftClick, COLORREF crRightClick, COLORREF crTrack);
SCNLIB_API void __stdcall ScnLib_GetCursorEffectsColors(COLORREF *crHighlight, COLORREF *crLeftClick, COLORREF *crRightClick, COLORREF *crTrack);
SCNLIB_API void __stdcall ScnLib_SetCursorEffectsImagesA(LPCSTR pcszHighlight, LPCSTR pcszLeftClick, LPCSTR pcszRightClick);
SCNLIB_API void __stdcall ScnLib_GetCursorEffectsImagesA(LPSTR pszHighlight, LPSTR pszLeftClick, LPSTR pszRightClick); // pszHighlight, pszLeftClick, pszRightClick >= 260 CHARs
SCNLIB_API void __stdcall ScnLib_SetCursorEffectsImagesW(LPCWSTR pcwszHighlight, LPCWSTR pcwszLeftClick, LPCWSTR pcwszRightClick);
SCNLIB_API void __stdcall ScnLib_GetCursorEffectsImagesW(LPWSTR pwszHighlight, LPWSTR pwszLeftClick, LPWSTR pwszRightClick); // pwszHighlight, pwszLeftClick, pwszRightClick >= 260 WCHARs

#ifdef __cplusplus
}
#endif

#endif //__SCNLIB_H__
