# ZD 录屏 SDK

高性能的原生API支持实时录制屏幕、摄像头、位图和音频，无系统延迟，兼容C#、C++和VB.NET，无需依赖外部运行时库或包。

## 简介

ZD 录屏 SDK 是一个功能丰富的屏幕录制软件开发库，可为您的软件提供先进的屏幕录制功能，包括创新的多源录制功能。通过集成该SDK，开发者可以快速实现专业级的屏幕录制功能，与从头开始开发此类功能相比，可以节省大量时间和成本。选择 ZD 录屏 SDK，可以高效、经济地提升您应用程序的功能。这个 SDK 不仅增加了高级功能，稳定性和专业品质都有保障，并可减轻维护工作。对于寻求使用前沿录屏技术来增强其应用程序的开发者来说，它是理想的解决方案，无需承担开发和维护复杂录屏功能的负担。使用 ZD 录屏 SDK 来助力您的应用程序 - 现代、高效、易用的屏幕录制解决方案的明智之选！

## 入门指南

### 系统要求

* 操作系统：Microsoft Windows Vista / 7 / 8 / 8.1 / 10 / 11.
* 编程语言：C# / VB.NET / Visual C++ / Delphi / C++Builder.

### 在微软Visual Studio中通过NuGet包管理器安装SDK（推荐方法）

1. 在解决方案资源管理器中右键单击您的项目，然后点击“管理NuGet程序包...”，这将为您的项目打开NuGet包管理器。
2. 在NuGet包管理器窗口中，默认会显示一个“浏览”标签。在这里，您可以输入“lu ping sdk”来搜索NuGet.org仓库中的`LuPingSDK`程序包。
3. 选择该包并点击您想要使用的包版本旁边的“安装”按钮。您可能需要接受许可协议来确认安装。审查安装包将对您的项目进行的更改，然后点击“确定”以接受更改。
4. 将下面提供的示例代码片段整合到您的项目中，并构建解决方案以确认NuGet包已正确集成到您的项目中。一旦构建成功，您就可以在项目中使用SDK的功能了。

### 直接从我们官方网站下载SDK压缩包，然后手动安装

1. 访问 [SDK下载页面](https://www.zd-soft.com/screen-recorder-sdk/download.html) 下载SDK的独立ZIP压缩包到您的电脑上，然后将其解压到一个临时文件夹。
2. 将SDK的`ScnLib\bin\x86\*.*`（32位系统）和`ScnLib\bin\x64\*.*`（64位系统）的运行时二进制文件复制到项目的对应执行目录中。
3. 从SDK的`ScnLib\include`和`ScnLib\lib`目录复制相应的头文件和库文件到您的项目的源目录，然后通过IDE的项目管理器将它们引用到您的项目中。
4. 将下面提供的示例代码片段整合到您的项目中并进行构建，即可验证SDK库是否已在项目环境中正确配置。一旦构建成功，您就可以在项目中使用SDK的功能了。

### 基本例程的C#代码示例

* 在应用程序启动时初始化SDK（这应该只在应用程序启动时执行一次）。
```csharp
ZDSoft.SDK.ScnLib_InitializeW("");
```
* 使用默认设置启动常规屏幕录制会话，通常在按钮点击事件处理器中触发。
```csharp
ZDSoft.SDK.ScnLib_StartRecording();
```
* 经过一段时间后，结束屏幕录制会话，这通常也是在按钮点击事件处理器中触发的。
```csharp
ZDSoft.SDK.ScnLib_StopRecording();
```
* 在应用程序关闭过程中卸载SDK（这应该只在应用程序关闭时执行一次）。
```csharp
ZDSoft.SDK.ScnLib_Uninitialize();
```
* 浏览位于 `C:\Users\YourName\Videos\` 的 `视频` 文件夹，以查看您刚刚录制的视频。

### 基本例程的C++代码示例

* 在主`.cpp`文件中包含SDK头文件和库文件。
```cpp
#include "ScnLib.h"
#pragma comment(lib, "ScnLib.lib")
```
* 在应用程序启动时初始化SDK（这应该只在应用程序启动时执行一次）。
```cpp
ScnLib_InitializeW(NULL);
```
* 使用默认设置启动常规屏幕录制会话，通常在按钮点击事件处理器中触发。
```cpp
ScnLib_StartRecording();
```
* 经过一段时间后，结束屏幕录制会话，这通常也是在按钮点击事件处理器中触发的。
```cpp
ScnLib_StopRecording();
```
* 在应用程序关闭过程中卸载SDK（这应该只在应用程序关闭时执行一次）。
```cpp
ScnLib_Uninitialize();
```
* 浏览位于 `C:\Users\YourName\Videos\` 的 `视频` 文件夹，以查看您刚刚录制的视频。

### 基本例程的VB.NET代码示例

* 在应用程序启动时初始化SDK（这应该只在应用程序启动时执行一次）。
```vbnet
ZDSoft.SDK.ScnLib_InitializeW("")
```
* 使用默认设置启动常规屏幕录制会话，通常在按钮点击事件处理器中触发。
```vbnet
ZDSoft.SDK.ScnLib_StartRecording()
```
* 经过一段时间后，结束屏幕录制会话，这通常也是在按钮点击事件处理器中触发的。
```vbnet
ZDSoft.SDK.ScnLib_StopRecording()
```
* 在应用程序关闭过程中卸载SDK（这应该只在应用程序关闭时执行一次）。
```vbnet
ZDSoft.SDK.ScnLib_Uninitialize()
```
* 浏览位于 `C:\Users\YourName\Videos\` 的 `视频` 文件夹，以查看您刚刚录制的视频。

### 基本例程的Delphi代码示例

* 在您打算使用 SDK 的源文件中，请按如下方式在 `uses` 部分包含 `ScnLib` ：
```delphi
uses Winapi.Windows, System.Classes, ..., ScnLib;
```
* 在应用程序启动时初始化SDK（这应该只在应用程序启动时执行一次）。
```delphi
ScnLib_InitializeW('');
```
* 使用默认设置启动常规屏幕录制会话，通常在按钮点击事件处理器中触发。
```delphi
ScnLib_StartRecording();
```
* 经过一段时间后，结束屏幕录制会话，这通常也是在按钮点击事件处理器中触发的。
```delphi
ScnLib_StopRecording();
```
* 在应用程序关闭过程中卸载SDK（这应该只在应用程序关闭时执行一次）。
```delphi
ScnLib_Uninitialize();
```
* 浏览位于 `C:\Users\YourName\Videos\` 的 `视频` 文件夹，以查看您刚刚录制的视频。

### 进阶C++示例代码片段展示如何同时录制多个摄像头和主屏幕

```cpp
// 将布局上下文切换到主屏幕块并存储前一个块索引
int oldBlock = ScnLib_SetLayoutContext(0);

// 设置主屏幕输出单独的视频（可选）
ScnLib_SetVideoPathW(L"C:\\Recordings\\Main Screen.mp4");

// 获取主屏幕视频分辨率
int videoWidth = 0, videoHeight = 0;
ScnLib_GetVideoResolution(&videoWidth, &videoHeight);

// 我们将把 3 个垂直堆叠的摄像头视图与主屏幕的右侧靠齐，每个视图都是视频高度的 1/3
videoHeight /= 3;
// 我们偏好长宽比为 4:3 的摄像头视图
videoWidth = videoHeight * 4 / 3;

// 将布局上下文切换到摄像头视图块 #1
ScnLib_SetLayoutContext(1);

// 设置摄像头 #1 视图输出单独的视频（可选）
ScnLib_SetVideoPathW(L"C:\\Recordings\\Webcam #1.mp4");

// 假定有不少于 3 个摄像头设备连接到了电脑，为摄像头 #1 视图选择第一个摄像头设备
ScnLib_SelectWebcamDevice(0);

// 将摄像头 #1 视图与右上角对齐，向右偏移其宽度，使其显示在主屏幕侧边
ScnLib_SetWebcamPosition(SCNLIB_POSITION_TOP_RIGHT, -videoWidth, 0);
ScnLib_SetWebcamViewSize(videoWidth, videoHeight);

// 将布局上下文切换到摄像头视图块 #2
ScnLib_SetLayoutContext(2);

// 设置摄像头 #2 视图输出单独的视频（可选）
ScnLib_SetVideoPathW(L"C:\\Recordings\\Webcam #2.mp4");

// 假定有不少于 3 个摄像头设备连接到了电脑，为摄像头 #2 视图选择第二个摄像头设备
ScnLib_SelectWebcamDevice(1);

// 将摄像头 #2 视图与右侧对齐，同时向右偏移其宽度，使其显示在主屏幕侧边
ScnLib_SetWebcamPosition(SCNLIB_POSITION_RIGHT, -videoWidth, 0);
ScnLib_SetWebcamViewSize(videoWidth, videoHeight);

// 将布局上下文切换到摄像头视图块#3
ScnLib_SetLayoutContext(3);

// 设置摄像头 #3 视图输出单独的视频（可选）
ScnLib_SetVideoPathW(L"C:\\Recordings\\Webcam #3.mp4");

// 假定有不少于 3 个摄像头设备连接到了电脑，为摄像头 #3 视图选择第三个摄像头设备
ScnLib_SelectWebcamDevice(2);

// 将摄像头 #3 视图与右下角对齐，向右偏移其宽度，使其显示在主屏幕侧边
ScnLib_SetWebcamPosition(SCNLIB_POSITION_BOTTOM_RIGHT, -videoWidth, 0);
ScnLib_SetWebcamViewSize(videoWidth, videoHeight);

// 将布局上下文切换到合成屏幕
ScnLib_SetLayoutContext(-1);

// 设置合成屏幕输出单独的视频
ScnLib_SetVideoPathW(L"C:\\Recordings\\Composition Screen.mp4");

// 恢复到之前的布局上下文
ScnLib_SetLayoutContext(oldBlock);

// 现在开始录制会话
ScnLib_StartRecording();
```

## 帮助

* 要查看SDK的版本历史记录，您可以前往：[https://www.zd-soft.com/screen-recorder-sdk/download.html](https://www.zd-soft.com/screen-recorder-sdk/download.html)

* 有关SDK API的详细信息，请参阅SDK包中附带的 `使用手册.chm`，或者在线查阅API参考资料：[https://www.zd-soft.com/screen-recorder-sdk/api/](https://www.zd-soft.com/screen-recorder-sdk/api/)

* 如果您对SDK有任何疑问或建议，请通过以下网址的在线表格与我们联系：[https://www.zd-soft.com/contact.html](https://www.zd-soft.com/contact.html)
